<?php

namespace App\Domain\Version\Service;

use App\Domain\Version\Repository\VersionRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class VersionService
{
    /**
     * @var VersionRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(VersionRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */

    public function ObtenerVersionApp():array{
        // Insert state
        return json_decode($this->repository->getAppV());
    }

}