<?php

namespace App\Domain\Users\Service;

use App\Domain\Users\Repository\UsersRepository;
use Psr\Http\Message\ServerRequestInterface as Request;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class UsersService
{
    /**
     * @var UsersRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(UsersRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(string $email, string $pass):array{
        return json_decode($this->repository->SearchRecord($email,$pass));
    }

    public function VerificarLogin(Request $request, string $email, string $pass):array{
        return $this->repository->LoginVerify($request, $email, $pass);
    }

    public function ActualizarRegistro(array $data):array{
        $result=$this->repository->UpdateRecord($data);
        return $result;
    }

    public function ActualizarCiudades(string $email, string $cities, int $city):array{
        $result = $this->repository->UpdateCity($email, $cities, $city);
        return $result;
    }

    public function EliminarRegistro(string $id):array {    
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }
}