<?php

namespace App\Domain\TypePurchase\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class TypePurchaseRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los sede
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array {

            $row = [
                'nom_tip_compra' => $data['name']
            ];

            try { 

                $lastInsertId = $this->connection->table('tipo_compra')->insertGetId($row);
                $vErr = 0;

                $result = [

                            'SqlState' => 'Transaccion ejecutada correctamente',
                            'ErrNumber' => $vErr,
                            'UniqueViolation' => 'Ok',
                            'Description' => 'El registro se creo correctamente',
                            'FullInfo' => $lastInsertId
                    
                        ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                    $result = [

                                'SqlState' => $error[0],
                                'ErrNumber' => $err,
                                'UniqueViolation' => $error[1],
                                'Description' => 'Ocurrio un error al momento de crear el registro',
                                'FullInfo' => trim($error[4])

                            ];
                // Note any method of class PDOException can be called on $ex.
              }
            
       return $result;  
    }

    public function SearchRecords():string {
        $payload=$this->connection->table('tipo_compra as t')
        ->Select('t.id_tip_compra as id', 't.nom_tip_compra as name', 
            $this->connection->raw('CASE WHEN c.id_compra IS NOT NULL THEN 1 ELSE 0 END as used'))
        ->LeftJoin('compra as c', 'c.fk_id_tip_compra', '=', 't.id_tip_compra')
        ->GroupBy('t.nom_tip_compra')
        ->sharedLock()->get();
        return $payload;  
    }

    public function SearchRecord(string $idCities):string{

        $ids = explode(",", $idCities);

        $payload=$this->connection->table('compra')
        ->select('id_sede as id', 'sede.nombre as name', $this->connection->raw('COUNT(ubicacion.id_ubicacion) as countLocations'), 'fk_id_city as foKeyCity')
        ->whereIn('fk_id_city', $ids)
        ->leftJoin('ubicacion','sede.id_sede','=','ubicacion.fk_id_sede')
        ->groupBy('sede.nombre')->get();
        return $payload;  
    }

    public function DeleteRecord(int $id):array {

      try { 

        $this->connection->table('tipo_compra')
        ->where(['id_tip_compra' => $id])
        ->delete();

            $result = [

                'SqlState' => 'Transaccion ejecutada correctamente',
                'ErrNumber' => '0',
                'UniqueViolation' => 'Ok',
                'Description' => 'El registro se elimino correctamente',
                'FullInfo' => 'Ok'

            ];

        }catch(\Illuminate\Database\QueryException $ex){ 
            
            $error=explode(":",$ex->getMessage());
            $err=substr($error[0],9,-1);
            $result = [
                
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de eliminar el registro',
                        'FullInfo' => trim($error[4])
                
                    ];
            // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

    public function UpdateRecord(array $data):array {

        $id = $data['id'];

        $row = [
            'nom_tip_compra' => $data['name']
        ];

            try { 
                $this->connection->table('tipo_compra')
                ->where(['id_tip_compra' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'Ok'
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 
                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4])
                ];

                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

}