<?php

namespace App\Domain\Token\Service;

use App\Domain\Token\Repository\TokenRepository;
use Psr\Http\Message\ServerRequestInterface as Request;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;

/**
 * Service.
 */

final class TokenService {
    /**
     * @var TokenRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(TokenRepository $repository) {
        $this->repository = $repository;
    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function ValidarToken(Request $request):array{
        $result = $this->repository->ValidateToken($request);
        return $result;
    }
}