<?php

namespace App\Domain\Shopping\Service;

use App\Domain\Shopping\Repository\ShoppingRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Slim\Psr7\UploadedFile;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class ShoppingService
{
    /**
     * @var ShoppingRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(ShoppingRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function RegistrosSinPDF(string $citiesId):array{
        // Insert state
        return json_decode($this->repository->RecordsWithoutPDF($citiesId));
    }

    public function DescargarPDF(int $id): ?string {
        return $this->repository->DownloadPDF($id);
    }

    public function BuscarRegistro(string $idCities):array{
        return json_decode($this->repository->SearchRecord($idCities));
    }


    public function ActualizarRegistro(array $data):array{
        $result=$this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(string $id):array {
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }

    public function SubirArchivo(UploadedFile $file, int $id):array {
        $result = $this->repository->UploadFile($file, $id);
        return $result;
    }

}