<?php

namespace App\Domain\Responsible\Service;

use App\Domain\Responsible\Repository\ResponsibleRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class ResponsibleService
{
    /**
     * @var ResponsibleRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(ResponsibleRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(string $idCities):array{
        return json_decode($this->repository->SearchRecord($idCities));
    }


    public function ActualizarRegistro(array $data):array {
        $result=$this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(int $id):array {
        $result = $this->repository->DeleteRecord($id);
        return $result;
    }

    public function SeleccionarContadorActivos(int $responsibleId): array {
        return json_decode($this->repository->SelectWithCountAsset($responsibleId));
    }
 }