<?php

namespace App\Domain\Responsible\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class ResponsibleRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los funci_responsable
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array {

            $row = [
                'nom_func_respon' => $data['name']
            ];

            try { 

                $lastInsertId = $this->connection->table('funci_responsable')->insertGetId($row);
                $vErr = 0;

                $result = [

                            'SqlState' => 'Transaccion ejecutada correctamente',
                            'ErrNumber' => $vErr,
                            'UniqueViolation' => 'Ok',
                            'Description' => 'El registro se creo correctamente',
                            'FullInfo' => $lastInsertId
                        ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                $err=substr($error[0],9,-1);

                    $result = [

                                'SqlState' => $error[0],
                                'ErrNumber' => $err,
                                'UniqueViolation' => $error[1],
                                'Description' => 'Ocurrio un error al momento de crear el registro',
                                'FullInfo' => trim($error[4])
                            ];
                // Note any method of class PDOException can be called on $ex.
              }
            
       return $result;
    }

    public function SearchRecords():string {
        $payload = $this->connection->table('funci_responsable as f')
        ->Select('id_func_respon as id', 'nom_func_respon as name', 
                $this->connection->raw('CASE WHEN a.id_activo IS NOT NULL THEN 1 ELSE 0 END as used'))
        ->leftJoin('activos as a', 'a.fk_id_func_respon', '=', 'f.id_func_respon')
        ->OrderBy('name')
        ->GroupBy('f.nom_func_respon')
        ->sharedLock()->get();
        return $payload;  
    }

    public function SearchRecord(string $idCities):string{

        $ids = explode(",", $idCities);

        $payload=$this->connection->table('funci_responsable')
        ->select('id_funci_responsable as id', 'funci_responsable.nombre as name', $this->connection->raw('COUNT(ubicacion.id_ubicacion) as countLocations'), 'fk_id_city as foKeyCity')
        ->whereIn('fk_id_city', $ids)
        ->leftJoin('ubicacion','funci_responsable.id_funci_responsable','=','ubicacion.fk_id_funci_responsable')
        ->groupBy('funci_responsable.nombre')->get();
        return $payload;  
    }

    public function DeleteRecord(int $id):array {

      try { 

        $this->connection->table('funci_responsable')
        ->where(['id_func_respon' => $id])
        ->delete();

            $result = [

                'SqlState' => 'Transaccion ejecutada correctamente',
                'ErrNumber' => '0',
                'UniqueViolation' => 'Ok',
                'Description' => 'El registro se elimino correctamente',
                'FullInfo' => 'Ok'
            ];

        }catch(\Illuminate\Database\QueryException $ex){ 
            
            $error=explode(":",$ex->getMessage());
            $err=substr($error[0],9,-1);
            $result = [
                
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de eliminar el registro',
                        'FullInfo' => trim($error[4])
                    ];
            // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

    public function UpdateRecord(array $data):array {

        $id = $data['id'];

        $row = [
            'nom_func_respon' => $data['name']
        ];

            try { 
                $this->connection->table('funci_responsable')
                ->where(['id_func_respon' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'Ok'
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 
                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4])
                ];

                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

    public function SelectWithCountAsset(int $responsibleId): string {

        $payload = $this->connection->table('funci_responsable as f')
        ->select('f.id_func_respon as id', 'f.nom_func_respon as name',
                 $this->connection->raw('count(activos.id_activo) as countAssets'))
        ->Join('activos', 'f.id_func_respon', '=', 'activos.fk_id_func_respon')
        ->Where('f.id_func_respon', '=', $responsibleId)
        ->GroupBy('f.nom_func_respon')
        ->get();

        return $payload;
    }
}