<?php

namespace App\Domain\ReportFormat\Service;

use App\Domain\ReportFormat\Repository\ReportFormatRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class ReportFormatService
{
    /**
     * @var ReportFormatRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(ReportFormatRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarFormato(string $formatId):array{
        return json_decode($this->repository->SearchFormat($formatId));
    }

    public function ActualizarRegistro(array $data):array{
        $result=$this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(string $id):array {
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }
}