<?php

namespace App\Domain\ReportFormat\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class ReportFormatRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los funci_responsable
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array{

            $row = [
                'nombre' => $data['name'],
                'fk_id_city' => $data['foKeyCity']
            ];

            try { 

                $lastInsertId = $this->connection->table('funci_responsable')->insertGetId($row);
                $vErr = 0;

                $result = [

                            'SqlState' => 'Transaccion ejecutada correctamente',
                            'ErrNumber' => $vErr,
                            'UniqueViolation' => 'Ok',
                            'Description' => 'El registro se creo correctamente',
                            'FullInfo' => 'Ok',
                            'LastInsertId' => $lastInsertId,
                    
                        ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                    $result = [

                                'SqlState' => $error[0],
                                'ErrNumber' => $err,
                                'UniqueViolation' => $error[1],
                                'Description' => 'Ocurrio un error al momento de crear el registro',
                                'FullInfo' => trim($error[4]),
                                'lastInsertId' => 'Error',

                            ];
                // Note any method of class PDOException can be called on $ex.
              }
            
       return $result;
    }

    public function SearchRecords():string {
        $payload=$this->connection->table('funci_responsable')
        ->Select('id_func_respon as id', 'nom_func_respon as name')
        ->OrderBy('name')
        ->sharedLock()->get();
        return $payload;  
    }

    public function SearchFormat(string $formatId):string {
        $payload = $this->connection->table('formato_reporte')
        ->Select('id', 'formato as format')
        ->Where(['id' => $formatId])
        ->get();
        return $payload;  
    }

    public function DeleteRecord(string $id):array {

      try { 

        $this->connection->table('funci_responsable')
        ->where(['id_funci_responsable' => $id])
        ->delete();

            $result = [

                'SqlState' => 'Transaccion ejecutada correctamente',
                'ErrNumber' => '0',
                'UniqueViolation' => 'Ok',
                'Description' => 'El registro se elimino correctamente',
                'FullInfo' => 'Ok',
                'lastInsertId' => '0',

            ];

        }catch(\Illuminate\Database\QueryException $ex){ 
            
            $error=explode(":",$ex->getMessage());
            $err=substr($error[0],9,-1);
            $result = [
                
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de eliminar el registro',
                        'FullInfo' => trim($error[4]),
                        'lastInsertId' => '0',
                
                    ];
            // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

    public function UpdateRecord(array $data):array{

        $id = $data['id'];

        $row = [
            'nombre' => $data['name'],
            'fk_id_city' => $data['foKeyCity']
        ];

            try { 
                $this->connection->table('funci_responsable')
                ->where(['id_funci_responsable' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'Ok',
                        'lastInsertId' => '0'
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 
                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4]),
                        'lastInsertId' => '0'
                ];

                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

}