<?php

namespace App\Domain\Logger\Service;

use App\Domain\Logger\Repository\LoggerRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class LoggerService {
    /**
     * @var LoggerRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(LoggerRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }
    
    public function ObtenerItemsPorUbi(string $fk_id):array{
        // Insert state
        return json_decode($this->repository->GetItemsForLocat($fk_id));
    }

    public function BuscarRegistro(string $email, string $pass):array{
        return json_decode($this->repository->SearchRecord($email,$pass));
    }
    
    public function ActualizarRegistro(array $data,string $id):array
    {
        $result=$this->repository->UpdateRecord($data,$id);
        return $result;

    }

    public function EliminarRegistro(string $id):array
    {
        
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }
    /**
     * Input validation.
     *
     * @param array $data The form data
     *
     * @throws ValidationException
     *
     * @return void
     */
    private function validateNewState(array $data): void
    {
        $errors = [];

        // Here you can also use your preferred validation library

        if (empty($data['id'])) {
            $errors['id'] = 'Codigo de la ciudad es requerido';
        }

        if (empty($data['nombre'])) {
            $errors['nombre'] = 'Nombre de la ciudad es requerido';
        }

        if (empty($data['id_departamento'])) {
            $errors['id_departamento'] = 'Seleccione la region a la que pertenece';
        }
        //Validar correo electronico
        /*if (empty($data['email'])) {
            $errors['email'] = 'Input required';
        } elseif (filter_var($data['email'], FILTER_VALIDATE_EMAIL) === false) {
            $errors['email'] = 'Invalid email address';
        }*/

        if ($errors) {
            throw new ValidationException('Por favor ingrese los datos adecuamente', $errors);
        }
    }
}