<?php

namespace App\Domain\Locations\Service;

use App\Domain\Locations\Repository\LocationsRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class LocationsService
{
    /**
     * @var LocationsRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(LocationsRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data): array {
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros(): array {
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }
    
    public function ObtenerItemsPorUbi(string $fk_id): array {
        // Insert state
        return json_decode($this->repository->GetItemsForLocat($fk_id));
    }

    public function BuscarRegistro(int $id): array{
        return json_decode($this->repository->SearchRecord($id));
    }

    public function BuscarConEstadoPorId(int $foKeyHeadquaarters): array {
        return json_decode($this->repository->SearchWithStatusByFoKey($foKeyHeadquaarters));
    }

    public function RegistrosEnCiudad(String $idCities): array {
        return json_decode($this->repository->RecordsInCity($idCities));
    }
    
    public function ActualizarRegistro(array $data): array {
        $result = $this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(int $locationId): array {
        $result = $this->repository->DeleteRecord($locationId);
        return $result;
    }
}