<?php

namespace App\Domain\Headquarters\Service;

use App\Domain\Headquarters\Repository\HeadquartersRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class HeadquartersService
{
    /**
     * @var HeadquartersRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(HeadquartersRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(string $idCities):array{
        return json_decode($this->repository->SearchRecord($idCities));
    }

    public function BuscarPorCiudadConEstado(string $cityId): array {
        return json_decode($this->repository->SearchByCitiesWithStatus($cityId));
    }

    public function BuscarCiudadConEstado(string $cityId): array {
        return json_decode($this->repository->SearchJoinCityWithStatus($cityId));
    }

    public function ActualizarRegistro(array $data):array{
        $result = $this->repository->UpdateRecord($data);
        return $result;
    }

    public function ActualizarForaneaCiudad(array $data): array {
        $result = $this->repository->UpdateFoKeyCity($data);
        return $result;
    }

    public function EliminarRegistro(string $id):array {
        $result = $this->repository->DeleteRecord($id);
        return $result;
    }

}