<?php

namespace App\Domain\Headquarters\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class HeadquartersRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los sede
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array {

            $row = [
                'nombre' => $data['name'],
                'fk_id_city' => $data['foKeyCity']
            ];

            try { 

                $lastInsertId = $this->connection->table('sede')->insertGetId($row);
                $vErr = 0;

                $result = [

                            'SqlState' => 'Transaccion ejecutada correctamente',
                            'ErrNumber' => $vErr,
                            'UniqueViolation' => 'Ok',
                            'Description' => 'El registro se creo correctamente',
                            'FullInfo' => $lastInsertId
                    
                        ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                    $result = [

                                'SqlState' => $error[0],
                                'ErrNumber' => $err,
                                'UniqueViolation' => $error[1],
                                'Description' => 'Ocurrio un error al momento de crear el registro',
                                'FullInfo' => trim($error[4])

                            ];
                // Note any method of class PDOException can be called on $ex.
              }
            
       return $result;
    }

    public function SearchRecords():string {
        $payload=$this->connection->table('sede')->sharedLock()->get();
        return $payload;  
    }

    public function SearchRecord(string $cityId):string {

        $ids = explode(",", $cityId);

        $payload=$this->connection->table('sede')
        ->select('id_sede as id', 'sede.nombre as name', $this->connection->raw('COUNT(ubicacion.id_ubicacion) as countLocations'), 'fk_id_city as foKeyCity')
        ->whereIn('fk_id_city', $ids)
        ->leftJoin('ubicacion','sede.id_sede','=','ubicacion.fk_id_sede')
        ->groupBy('sede.nombre')->get();
        return $payload;  
    }

    public function SearchJoinCityWithStatus(string $cityId): string {

        $ids = explode(",", $cityId);

        $payload = $this->connection->table('sede as s')
        ->select('s.id_sede as id', 's.nombre as name', 
            $this->connection->raw('COUNT(u.id_ubicacion) as countLocations'), 's.fk_id_city as foKeyCity', 'c.city_name as cityName', 
            $this->connection->raw('CASE WHEN u.id_ubicacion IS NOT NULL THEN 1 ELSE 0 END as used'))
        ->leftJoin('ubicacion as u','s.id_sede','=','u.fk_id_sede')
        ->Join('city as c', 'c.id', '=', 's.fk_id_city')
        ->GroupBy('s.nombre')
        ->whereIn('fk_id_city', $ids)->get();
        return $payload; 
    }

    public function SearchByCitiesWithStatus(string $cityId): string {

        $ids = explode(",", $cityId);

        $payload = $this->connection->table('sede as s')
        ->select('s.id_sede as id', 's.nombre as name', $this->connection->raw('COUNT(u.id_ubicacion) as countLocations'), 'fk_id_city as foKeyCity', $this->connection->raw('CASE WHEN u.id_ubicacion IS NOT NULL THEN 1 ELSE 0 END as used'))
        ->leftJoin('ubicacion as u','s.id_sede','=','u.fk_id_sede')
        ->GroupBy('s.nombre')
        ->whereIn('fk_id_city', $ids)->get();
        return $payload; 
    }

    public function DeleteRecord(string $id):array {

      try { 

        $this->connection->table('sede')
        ->where(['id_sede' => $id])
        ->delete();

            $result = [

                'SqlState' => 'Transaccion ejecutada correctamente',
                'ErrNumber' => '0',
                'UniqueViolation' => 'Ok',
                'Description' => 'El registro se elimino correctamente',
                'FullInfo' => 'Ok'
            ];

        }catch(\Illuminate\Database\QueryException $ex){ 
            
            $error=explode(":",$ex->getMessage());
            $err=substr($error[0],9,-1);
            $result = [
                
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de eliminar el registro',
                        'FullInfo' => trim($error[4])
                    ];
            // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

    public function UpdateRecord(array $data):array{

        $id = $data['id'];

        $row = [
            'nombre' => $data['name'],
            'fk_id_city' => $data['foKeyCity']
        ];

            try { 

                $this->connection->table('sede')
                ->where(['id_sede' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'Ok'
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4])
                    ];

                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

    public function UpdateFoKeyCity(array $data): array {

        $id = $data['id'];

        $row = [
            'fk_id_city' => $data['foKeyCity']
        ];

        try {


            $this->connection->table("sede")
            ->where(['id_sede' => $id])
            ->update($row);

            $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El cambio de ciudad fue exitoso',
                        'FullInfo' => 'Ok'
                    ];

        } catch(\Illuminate\Database\QueryException $ex) {

            //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de cambiar de ciudad',
                        'FullInfo' => trim($error[4])
                    ];

                // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

}