<?php

namespace App\Domain\Fields\Service;

use App\Domain\Fields\Repository\FieldsRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class FieldsService
{
    /**
     * @var FieldsRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(FieldsRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarIdCategoria(int $categoryId):array{
        return json_decode($this->repository->FindCatId($categoryId));
    }

    public function BuscarPorEstado(int $categoryId): array {
        return json_decode($this->repository->SearchWithStatusByFoKey($categoryId));
    }

    public function ActualizarRegistro(array $data):array {
        $result = $this->repository->UpdateRecord($data,$id);
        return $result;
    }

    public function EliminarRegistro(string $id):array
    {
        
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }

}