<?php

namespace App\Domain\Dependency\Service;

use App\Domain\Dependency\Repository\DependencyRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class DependencyService
{
    /**
     * @var DependencyRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(DependencyRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(string $id):array{
        return json_decode($this->repository->SearchRecord($id));
    }

    public function BuscarConEstadoPadre(string $citiesId): array {
        return json_decode($this->repository->SearchWithParentStatus($citiesId));
    }

    public function BuscarConEstadoCiudad(string $citiesId): array {
        return json_decode($this->repository->SearchWithStatusCity($citiesId));
    }

    public function ActualizarRegistro(array $data):array{
        $result=$this->repository->UpdateRecord($data);
        return $result;
    }

    public function ActualizarForaneaCiudad(array $data) {
        $result = $this->repository->UpdateFoKeyCity($data);
        return $result;
    }

    public function EliminarRegistro(int $fieldId):array {
        $result = $this->repository->DeleteRecord($fieldId);
        return $result;
    }
}