<?php

namespace App\Domain\City\Service;

use App\Domain\City\Repository\CityRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class CityService
{
    /**
     * @var CityRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(CityRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(string $ids):array{
        return json_decode($this->repository->SearchRecord($ids));
    }

    public function ActualizarRegistro(array $data,string $id):array{
        $result=$this->repository->UpdateRecord($data,$id);
        return $result;

    }
    
    public function EliminarRegistro(string $id):array
    {
        
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }
}