<?php

namespace App\Domain\City\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class CityRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los usuarios
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $City):array {

            $row = [
                'city_name' => $City['city_name']
            ];

            try { 

                $lastInsertId = $this->connection->table('city')->insertGetId($row);
                $vErr=0;
                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => $vErr,
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se creo correctamente',
                        'FullInfo' => $lastInsertId
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de crear el registro',
                        'FullInfo' => trim($error[4]),
                ];
                
              }
            
       return $result;
    }

    public function SearchRecords():string {
        $payload=$this->connection->table('city')->sharedLock()->get();
        return $payload;  
    }

    public function SearchRecord(string $ids):string {

        $ids = explode(",", $ids);

        $payload=$this->connection->table('city')
        ->whereIn('id', $ids)->get();
        return $payload;  
    }

    public function DeleteRecord(string $id):array {

      try { 

      $this->connection->table('city')
      ->where(['id' => $id])
      ->delete();
      $result = [
                    
        'SqlState' => 'Transaccion ejecutada correctamente',
        'ErrNumber' => '0',
        'UniqueViolation' => 'Ok',
        'Description' => 'El registro se elimino correctamente',
        'FullInfo' => 'None'
    
      ];

      }catch(\Illuminate\Database\QueryException $ex){ 

        $error=explode(":",$ex->getMessage());
        $err=substr($error[0],9,-1);
          $result = [
                'SqlState' => $error[0],
                'ErrNumber' => $err,
                'UniqueViolation' => $error[1],
                'Description' => 'Ocurrio un error al momento de eliminar el registro',
                'FullInfo' => trim($error[4]),
        ];
        // Note any method of class PDOException can be called on $ex.
      }

        return $result;

    }

    public function UpdateRecord(array $City, string $id):array{

        $row = [
            'city_name' => $City['city_name']
        ];

            try { 
                $this->connection->table('city')
                ->where(['id' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'None'
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 
                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);
                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4]),
                ];
                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

}