<?php

namespace App\Domain\Categories\Service;

use App\Domain\Categories\Repository\CategoriesRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;

/**
 * Service.
 */

final class CategoriesService {
    /**
     * @var CategoriesRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(CategoriesRepository $repository) {
        $this->repository = $repository;
    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }

    public function BuscarRegistro(int $cityId):array{
        return json_decode($this->repository->SearchRecord($cityId));
    }

    public function ActualizarRegistro(array $data):array{
        $result = $this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(int $id):array {
        $result = $this->repository->DeleteRecord($id);
        return $result;
    }

}