<?php

namespace App\Domain\Categories\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */

class CategoriesRepository {

    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */

    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los categorias
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array{

            $row = [
                'nombre' => $data['name']
            ];

            try { 

                $lastInsertId = $this->connection->table('categorias')->insertGetId($row);
                $vErr = 0;

                $result = [

                            'SqlState' => 'Transaccion ejecutada correctamente',
                            'ErrNumber' => $vErr,
                            'UniqueViolation' => 'Ok',
                            'Description' => 'El registro se creo correctamente',
                            'FullInfo' => $lastInsertId
                    
                        ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                    $result = [

                                'SqlState' => $error[0],
                                'ErrNumber' => $err,
                                'UniqueViolation' => $error[1],
                                'Description' => 'Ocurrio un error al momento de crear el registro',
                                'FullInfo' => trim($error[4])

                            ];
                // Note any method of class PDOException can be called on $ex.
              }
            
       return $result;
    }

    public function SearchRecords():string {
        $payload=$this->connection->table('categorias as ca')
        ->Select('ca.id_categoria as id', 'ca.nombre as name', 
            $this->connection->raw('CASE WHEN c.id_campo IS NOT NULL THEN 1 ELSE 0 END as used'))
        ->LeftJoin('campos as c', 'c.fk_id_categoria', '=', 'ca.id_categoria')
        ->groupBy('ca.nombre')
        ->orderby('ca.nombre')
        ->sharedLock()->get();
        return $payload;  
    }

    public function SearchRecord(int $categoryId):string {
        $payload=$this->connection->table('categorias')
        ->Select('id_categoria as id', 'nombre as name')
        ->Where(['id_categoria' => $categoryId])
        ->sharedLock()->get();
        return $payload;  
    }

    public function DeleteRecord(int $id):array {

      try { 

        $this->connection->table('categorias')
        ->where(['id_categoria' => $id])
        ->delete();

            $result = [

                'SqlState' => 'Transaccion ejecutada correctamente',
                'ErrNumber' => '0',
                'UniqueViolation' => 'Ok',
                'Description' => 'El registro se elimino correctamente',
                'FullInfo' => 'Ok'

            ];

        }catch(\Illuminate\Database\QueryException $ex){ 
            
            $error=explode(":",$ex->getMessage());
            $err=substr($error[0],9,-1);
            $result = [
                
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de eliminar el registro',
                        'FullInfo' => trim($error[4])
                
                    ];
            // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }

    public function UpdateRecord(array $data):array {

        $id = $data['id'];

        $row = [
            'nombre' => $data['name']
        ];

            try { 

                $this->connection->table('categorias')
                ->where(['id_categoria' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'Ok'
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                //var_dump($ex->getMessage());  
                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4])
                ];

                // Note any method of class PDOException can be called on $ex.
              }

            
       return $result;
    }

}