<?php

namespace App\Domain\AssetLog\Service;

use App\Domain\AssetLog\Repository\AssetLogRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;

/**
 * Service.
 */
final class AssetLogService {

    /**
     * @var AssetLogRepository
     */

    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */

    public function __construct(AssetLogRepository $repository){
        $this->repository = $repository;
    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data): array {
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros(): array{
        return json_decode($this->repository->SearchRecords());
    }

    public function ActualizarRegistro(array $data): array {
        $result = $this->repository->UpdateRecord($data);
        return $result;
    }

    public function EliminarRegistro(int $locationId): array {
        $result = $this->repository->DeleteRecord($locationId);
        return $result;
    }
}