<?php

namespace App\Domain\Activos\Service;

use App\Domain\Activos\Repository\ActivosRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class ActivosService
{
    /**
     * @var ActivosRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(ActivosRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result=$this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return json_decode($this->repository->SearchRecords());
    }
    
    public function BuscarRegistro(string $cities, int $offset, int $limit):array {
        return json_decode($this->repository->SearchRecord($cities, $offset, $limit));
    }

    public function BuscarSoloId():array{
        return json_decode($this->repository->SearchIdOnly($email,$pass));
    }

    public function BuscarIdResponsable(int $responsibleId):array{
        return json_decode($this->repository->SearchByIdRes($responsibleId));
    }

    public function FormatoReporte(string $cities, int $locationId, int $responsibleId) {
        return json_decode($this->repository->ReportFormat($cities, $locationId, $responsibleId));
    }

    public function ContarActivos(string $cities):array {
        return json_decode($this->repository->CountAssets($cities));
    }

    public function BuscarVistaPreviaRegistro(string $id):array{
        return $this->repository->SearchPreviewRecord($id);
    }

    public function ActualizarRegistro(array $data):array {
        $result = $this->repository->UpdateRecord($data);
        return $result;
    }

    public function ActualizarUbicacionActivo(array $data):array{
        $result=$this->repository->UpdateAssetLocation($data);
        return $result;
    }
    
    public function ActualizarGlobalFuncionario(string $idOld,string $idNew):array{
        $result=$this->repository->UpdateGlobalOfficial($idOld,$idNew);
        return $result;
    }

    public function EliminarRegistro(string $assetId):array{
        $result = $this->repository->DeleteRecord($assetId);
        return $result;
    }

    public function TransferirResponsable(int $responsibleId, int $newResponsibleId): array {
        return $this->repository->TransferResponsible($responsibleId, $newResponsibleId);
    }

    public function ActualizarForaneaResponsable(string $assetId, int $responsibleId): array {
        return $this->repository->UpdateFoKeyResponsible($assetId, $responsibleId);
    }

    public function BuscarRegistroPorId(string $assetId, string $cities): array {
        return json_decode($this->repository->SearchById($assetId, $cities));
    }

    public function TrasladoActivo(string $assetId, int $responsibleId, int $locationId): array {
        return $this->repository->TransferAsset($assetId, $responsibleId, $locationId);
    }

    public function categoriaActivoConCampos(string $id): array {
        return json_decode($this->repository->assetCategoryWithFields($id));
    }

    public function CambiarEstadoDelActivo(string $assetId, int $status): array {
        return $this->repository->ChangeAssetStatus($assetId, $status);
    }

    public function BuscarPorResponsable(string $cities, int $responsibleId): array {
        return json_decode($this->repository->SearchByResponsible($cities, $responsibleId));
    }

    public function BuscarPorDescripcion(string $cities, string $data): array {
        return json_decode($this->repository->SearchByDescription($cities, $data));
    }
}