<?php

namespace App\Domain\ActiveFields\Service;

use App\Domain\ActiveFields\Repository\ActiveFieldsRepository;
use App\Exception\ValidationException;
use App\Factory\LoggerFactory;
use Exception;
use Psr\Log\LoggerInterface;
use Psr\Http\Message\ResponseInterface as Response;
/**
 * Service.
 */
final class ActiveFieldsService
{
    /**
     * @var ActiveFieldsRepository
     */
    private $repository;
    
    /**
     * The constructor.
     *
     * @param SuppliesRepository $repository The repository
     */
    public function __construct(ActiveFieldsRepository $repository)
    {
        $this->repository = $repository;

    }

    /**
     * Create a new user.
     *
     * @param array $data The form data
     *
     * @return int The new user ID
     */
    
    public function InsertarRegistro(array $data):array{
        $result = $this->repository->InsertRecord($data);
        return $result;
    }

    public function BuscarRegistros():array{
        // Insert state
        return $this->repository->SearchRecords();
    }
    
    public function BuscarRegistro(string $email, string $pass):array{
        return json_decode($this->repository->SearchRecord($email,$pass));
    }

    public function ActualizarRegistro(array $data):array{
        $result=$this->repository->UpdateRecord($data,$id);
        return $result;
    }

    public function EliminarRegistro(string $id):array{
        $result=$this->repository->DeleteRecord($id);
        return $result;
    }
    
    public function ActualizarDescripcion(array $data): array {
        return $this->repository->UpdateDesc($data);
    }
}