<?php

namespace App\Domain\ActiveFields\Repository;

use PDO;
use Illuminate\Database\Connection;
use Exception;

/**
 * Repository.
 */
class ActiveFieldsRepository
{
    /**
     * @var PDO The database connection
     */
    private $connection;
    /**
     * Constructor.
     *
     * @param PDO $connection The database connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * Insert user row.
     *
     * @param array $datos de los usuarios
     *
     * @return int The new ID
     */
    
    public function InsertRecord(array $data):array {

            $row = [
                'fk_id_campo' => $data['foKeyField'],
                'fk_id_activo' => $data['foKeyAsset'],
                'descripcion' => $data['description']
            ];

            try { 

                $this->connection->table('campo_activo')->insert($row);
                $vErr = 0;
                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => $vErr,
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se creo correctamente',
                        'FullInfo' => 'Ok'
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 

                $error=explode(":",$ex->getMessage());
                  //$descripcion=
                $err=substr($error[0],9,-1);
                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de crear el registro',
                        'FullInfo' => trim($error[4]),
                ];
                // Note any method of class PDOException can be called on $ex.
                
              }
            
       return $result;
    }

    public function SearchRecord(string $email,string $pass):string{
        $payload=$this->connection->table('campo_activo')
        ->where('id_activo','=', $email)->get();
        return $payload;  
    } 

    public function SearchRecords():array{
      $payload=$this->connection->table('campo_activo')->get()->toArray();
      return $payload;  
    }
    
    public function DeleteRecord(string $id):array {

      try { 

      $this->connection->table('ActiveFields')
      ->where(['id' => $id])
      ->delete();
      $result = [
                    
        'SqlState' => 'Transaccion ejecutada correctamente',
        'ErrNumber' => '0',
        'UniqueViolation' => 'Ok',
        'Description' => 'El registro se elimino correctamente',
    
      ];

      }catch(\Illuminate\Database\QueryException $ex){ 
        //var_dump($ex->getMessage());  
        $error=explode(":",$ex->getMessage());
          //$descripcion=
        $err=substr($error[0],9,-1);
          $result = [
                'SqlState' => $error[0],
                'ErrNumber' => $err,
                'UniqueViolation' => $error[1],
                'Description' => 'Ocurrio un error al momento de eliminar el registro',
                'FullInfo' => trim($error[4]),
        ];
        // Note any method of class PDOException can be called on $ex.
      }

    return $result;
    }

    public function UpdateRecord(array $data): array{

        $row = [
            'fk_id_campo' => $ActiveFields['foKeyField'],
            'fk_id_activo' => $ActiveFields['foKeyAsset'],
            'descripcion' => $ActiveFields['descripcion']
        ];

            try { 

                $this->connection->table('campo_activo')
                ->where(['id_camp_act' => $id])
                ->update($row);

                $result = [
                    
                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'ok'
                    
                    ];

              } catch(\Illuminate\Database\QueryException $ex){ 
 
                $error=explode(":",$ex->getMessage());
                $err=substr($error[0],9,-1);

                  $result = [
                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4]),
                ];
                // Note any method of class PDOException can be called on $ex.
              }

       return $result;
    }

    public function UpdateDesc(array $data): array {

        $row = [
            'descripcion' => $data['description']
        ];

        try {

                $this->connection->table('campo_activo')
                ->where('id_camp_act', '=', $data['id'])
                ->update($row);

                $result = [

                        'SqlState' => 'Transaccion ejecutada correctamente',
                        'ErrNumber' => '0',
                        'UniqueViolation' => 'Ok',
                        'Description' => 'El registro se actualizo correctamente',
                        'FullInfo' => 'ok'
                ];

        } catch(\Illuminate\Database\QueryException $ex) {

             $error=explode(":",$ex->getMessage());
                $err=substr($error[0],9,-1);

                  $result = [

                        'SqlState' => $error[0],
                        'ErrNumber' => $err,
                        'UniqueViolation' => $error[1],
                        'Description' => 'Ocurrio un error al momento de actualizar el registro',
                        'FullInfo' => trim($error[4])
                ];
                // Note any method of class PDOException can be called on $ex.
        }

        return $result;
    }
}