<?php

namespace App\Action\Version;

use App\Domain\Version\Service\VersionService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class VersionAction
{
    private $VersionService;

    public function __construct(VersionService $VersionService)
    {
        $this->VersionService = $VersionService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {}

    public function getAppV(Request $request,Response $response){

        $payload=$this->VersionService->ObtenerVersionApp();
        //$response->getBody()->write(json_encode(['data' => $payload]));
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);

    }

}