<?php

namespace App\Action\Users;

use App\Domain\Users\Service\UsersService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class UsersAction
{
    private $UsersService;

    public function __construct(UsersService $UsersService)
    {
        $this->UsersService = $UsersService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response) {
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        // Invoke the Domain with inputs and retain the result
        $result=$this->UsersService->InsertarRegistro($data);

        // Transform the result into the JSON representation

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){
        $payload=$this->UsersService->BuscarRegistros();
        //$response->getBody()->write(json_encode(['data' => $payload]));
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        $email = $args['email'];
        $pass = $args['pass'];

        $payload=$this->UsersService->BuscarRegistro($email,$pass);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function LoginVerify(Request $request,Response $response,array $args){

        $email = $args['email'];
        $pass = $args['pass'];

        $payload=$this->UsersService->VerificarLogin($request, $email, $pass);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response){

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        $id = $data['email'];

        $result =$this->UsersService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }


    public function UpdateCities(Request $request, Response $response, array $args) {

        // get arguments
        $email = $args['email'];
        $cities = $args['cities'];
        $city = $args['city'];

        $result = $this->UsersService->ActualizarCiudades($email, $cities, $city);
        $response->getBody()->write(json_encode($result));

        return $response->withHeader('Content-Type', 'application/json')
                        ->withStatus(200);
    }

    public function DeleteRecord(Request $request,Response $response,array $args){
        $id = $args['id'];
        $result =$this->UsersService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}