<?php

namespace App\Action\TypePurchase;

use App\Domain\TypePurchase\Service\TypePurchaseService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class TypePurchaseAction {

    private $TypePurchaseService;

    public function __construct(TypePurchaseService $TypePurchaseService) {
        $this->TypePurchaseService = $TypePurchaseService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request, Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result = $this->TypePurchaseService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->TypePurchaseService->BuscarRegistros();
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }


    public function SearchRecord(Request $request,Response $response,array $args){

        //id city for get data
        $idCities = $args['idCities'];

        $payload=$this->TypePurchaseService->BuscarRegistro($idCities);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response,array $args){
        
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->TypePurchaseService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['purchaseId'];
        $result = $this->TypePurchaseService->EliminarRegistro($id);    
         
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}