<?php

namespace App\Action\Token;

use App\Domain\Token\Service\TokenService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class TokenAction {
    private $TokenService;

    public function __construct(TokenService $TokenService)
    {
        $this->TokenService = $TokenService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function ValidateToken(Request $request,Response $response) {
    
        // Invoke the Domain with inputs and retain the result
        $result = $this->TokenService->ValidarToken($request);

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }
}