<?php

namespace App\Action\Shopping;

use App\Domain\Shopping\Service\ShoppingService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class ShoppingAction {

    private $ShoppingService;

    public function __construct(ShoppingService $ShoppingService) {
        $this->ShoppingService = $ShoppingService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result=$this->ShoppingService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->ShoppingService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        //$response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function RecordsWithoutPDF(Request $request, Response $response,array $args) {

        $citiesId = $args['citiesId'];

        $payload = $this->ShoppingService->RegistrosSinPDF($citiesId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201); 
    }

    public function SearchRecord(Request $request, Response $response, array $args){
 
        //id city for get data
        $idCities = $args['idCities'];

        $payload=$this->ShoppingService->BuscarRegistro($idCities);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function DownloadPDF(Request $request, Response $response, array $args){

        // get id of the shopping
        $shoppingId = $args['shoppingId'];

        $payload = $this->ShoppingService->DescargarPDF($shoppingId);
        $response->getBody()->write($payload);

        return $response
                ->withHeader('Content-Type', 'application/pdf')
                ->withHeader('Content-Disposition', 'attachment; filename="archivo.pdf"')
                ->withStatus(201);
    }

    public function UpdateRecord(Request $request,Response $response,array $args){
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->ShoppingService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['shoppingId'];
        $result = $this->ShoppingService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function UploadFile(Request $request, Response $response, array $args) {

        //collect input from the HTTP request
        $file = $request->getUploadedFiles()['file'];
        $id = $args['shoppingId'];

        //invoke the Domain with inputs and retain the result
        $result=$this->ShoppingService->SubirArchivo($file, $id);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

}