<?php

namespace App\Action\Responsible;

use App\Domain\Responsible\Service\ResponsibleService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class ResponsibleAction {

    private $ResponsibleService;

    public function __construct(ResponsibleService $ResponsibleService) {
        $this->ResponsibleService = $ResponsibleService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result=$this->ResponsibleService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->ResponsibleService->BuscarRegistros();
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        //id city for get data
        $idCities = $args['idCities'];

        $payload=$this->ResponsibleService->BuscarRegistro($idCities);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function SelectWithCountAsset(Request $request, Response $response, array $args) {

        $responsibleId = $args['responsibleId'];

        $payload = $this->ResponsibleService->SeleccionarContadorActivos($responsibleId);
        $response->getBody()->write(json_encode($payload));
        
        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(200);
    }

    public function UpdateRecord(Request $request, Response $response, array $args){

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->ResponsibleService->ActualizarRegistro($data); 
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['responsibleId'];

        $result = $this->ResponsibleService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }
}