<?php

namespace App\Action\ReportFormat;

use App\Domain\ReportFormat\Service\ReportFormatService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class ReportFormatAction {

    private $ReportFormatService;

    public function __construct(ReportFormatService $ReportFormatService) {
        $this->ReportFormatService = $ReportFormatService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result=$this->ReportFormatService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->ReportFormatService->BuscarRegistros();
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchFormat(Request $request,Response $response,array $args){

        //id city for get data
        $formatId = $args['formatId'];

        $payload=$this->ReportFormatService->BuscarFormato($formatId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response,array $args){
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->ReportFormatService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['idReportFormat'];
        $result = $this->ReportFormatService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }
}