<?php

namespace App\Action\Logger;

use App\Domain\Logger\Service\LoggerService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class LoggerAction {

    private $LoggerService;

    public function __construct(LoggerService $LoggerService) {
        $this->LoggerService = $LoggerService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response){

        $data = (array)$request->getParsedBody();
        $result = $this->LoggerService->InsertarRegistro($data);

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->LoggerService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        //$response->getBody()->write(json_encode($payload));
        
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }
    
    public function GetItemsForLocat(Request $request,Response $response,array $args){

        //Get data
        $fk_id = $args['fk_id'];

        $payload=$this->LoggerService->ObtenerItemsPorUbi($fk_id);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  

    }

    public function SearchRecord(Request $request,Response $response,array $args){

        $email = $args['email'];
        $pass = $args['pass'];

        $payload=$this->LoggerService->BuscarRegistro($email,$pass);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response,array $args){
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        $id = $args['id'];
        $result =$this->LoggerService->ActualizarRegistro($data,$id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args){
        $id = $args['id'];
        $result =$this->LoggerService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}