<?php

namespace App\Action\Locations;

use App\Domain\Locations\Service\LocationsService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class LocationsAction
{
    private $LocationsService;

    public function __construct(LocationsService $LocationsService)
    {
        $this->LocationsService = $LocationsService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        
        // Invoke the Domain with inputs and retain the result
        $result = $this->LocationsService->InsertarRegistro($data);

        // Transform the result into the JSON representation

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){
        $payload=$this->LocationsService->BuscarRegistros();
        //$response->getBody()->write(json_encode(['data' => $payload]));
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }
    
    public function GetItemsForLocat(Request $request,Response $response,array $args){

        //Get data
        $fk_id = $args['fk_id'];

        $payload=$this->LocationsService->ObtenerItemsPorUbi($fk_id);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  

    }

    public function SearchRecord(Request $request,Response $response,array $args){

        $id = $args['id'];

        $payload=$this->LocationsService->BuscarRegistro($id);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function SearchWithStatusByFoKey(Request $request, Response $response, array $args) {

        // get data
        $foKeyHeadquarters = $args['headquartersId'];
        $payload = $this->LocationsService->BuscarConEstadoPorId($foKeyHeadquarters);

        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201); 
    }

    public function RecordsInCity(Request $request,Response $response,array $args) {

        // get items for city
        $idCities = $args['cityId'];

        $payload=$this->LocationsService->RegistrosEnCiudad($idCities);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        $result = $this->LocationsService->ActualizarRegistro($data);     

        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $locationId = $args['locationId'];
        $result = $this->LocationsService->EliminarRegistro($locationId);

        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}