<?php

namespace App\Action\Headquarters;

use App\Domain\Headquarters\Service\HeadquartersService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class HeadquartersAction {

    private $HeadquartersService;

    public function __construct(HeadquartersService $HeadquartersService) {
        $this->HeadquartersService = $HeadquartersService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result=$this->HeadquartersService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->HeadquartersService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        //$response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        //id city for get data
        $idCities = $args['cityId'];

        $payload=$this->HeadquartersService->BuscarRegistro($idCities);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function SearchByCitiesWithStatus(Request $request, Response $response, array $args) {

        //id city for get data
        $cityId = $args['cityId'];

        $payload = $this->HeadquartersService->BuscarPorCiudadConEstado($cityId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);
    }

    public function SearchJoinCityWithStatus(Request $request, Response $response, array $args) {

        // id city for get data
        $cityId = $args['cityId'];

        $payload = $this->HeadquartersService->BuscarCiudadConEstado($cityId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);
    }

    public function UpdateRecord(Request $request, Response $response, array $args){

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result = $this->HeadquartersService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function UpdateFoKeyCity(Request $request, Response $response, array $args) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result = $this->HeadquartersService->ActualizarForaneaCiudad($data);
        $response->getBody()->write(json_encode($result));

        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(200);
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['headquartersId'];

        $result = $this->HeadquartersService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}