<?php

namespace App\Action\Fields;

use App\Domain\Fields\Service\FieldsService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class FieldsAction
{
    private $FieldsService;

    public function __construct(FieldsService $FieldsService)
    {
        $this->FieldsService = $FieldsService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response) {
        
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        // Invoke the Domain with inputs and retain the result
        $result=$this->FieldsService->InsertarRegistro($data);

        // Transform the result into the JSON representation

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){
        $payload=$this->FieldsService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        //$response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function FindCatId(Request $request,Response $response,array $args){

        $categoryId = $args['categoryId'];

        $payload=$this->FieldsService->BuscarIdCategoria($categoryId);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }
 
    
    public function SearchWithStatusByFoKey(Request $request, Response $response, array $args) {

        // get category id
        $categoryId = $args['categoryId'];
        $payload = $this->FieldsService->BuscarPorEstado($categoryId);

        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);
    }
 

    public function UpdateRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result = $this->FieldsService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $fieldId = $args['fieldId'];
        $result = $this->FieldsService->EliminarRegistro($fieldId);     
        
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}