<?php

namespace App\Action\Dependency;

use App\Domain\Dependency\Service\DependencyService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class DependencyAction {

    private $DependencyService;

    public function __construct(DependencyService $DependencyService) {
        $this->DependencyService = $DependencyService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        //collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        //invoke the Domain with inputs and retain the result
        $result=$this->DependencyService->InsertarRegistro($data);

        //build the HTTP response | Transform the result into the JSON representation
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload=$this->DependencyService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        //$response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchWithParentStatus(Request $request, Response $response, array $args) {

        $citiesId = $args['citiesId'];
        $payload = $this->DependencyService->BuscarConEstadoPadre($citiesId);
        $response->getBody()->Write(json_encode($payload));
        
        return $response
                ->WithHeader('Content-Type', 'application/json')
                ->withStatus(201);
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        //id city for get data
        $id = $args['cityId'];

        $payload=$this->DependencyService->BuscarRegistro($id);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function SearchWithStatusCity(Request $request, Response $response, array $args) {

        $citiesId = $args['citiesId'];
        $payload = $this->DependencyService->BuscarConEstadoCiudad($citiesId);
        $response->getBody()->Write(json_encode($payload));
        
        return $response
                ->WithHeader('Content-Type', 'application/json')
                ->withStatus(201);
    }

    public function UpdateRecord(Request $request,Response $response,array $args){
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->DependencyService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function UpdateFoKeyCity(Request $request, Response $response, array $args) {

        $data = (array)$request->getParsedBody();

        $result = $this->DependencyService->ActualizarForaneaCiudad($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);  
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['dependencyId'];

        $result = $this->DependencyService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}