<?php

namespace App\Action\AssetLog;

use App\Domain\AssetLog\Service\AssetLogService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class AssetLogAction {

    private $AssetLogService;

    public function __construct(AssetLogService $AssetLogService) {
        $this->AssetLogService = $AssetLogService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface { }

    public function InsertRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        // Invoke the Domain with inputs and retain the result
        $result = $this->AssetLogService->InsertarRegistro($data);

        // Transform the result into the JSON representation

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){

        $payload = $this->AssetLogService->BuscarRegistros();
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }


    public function UpdateRecord(Request $request,Response $response,array $args) {


        $data = (array)$request->getParsedBody();
        $id = $data['id'];

        $result = $this->AssetLogService->ActualizarRegistro($data,$id);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $id = $args['id'];

        $result = $this->AssetLogService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

}