<?php

namespace App\Action\Activos;

use App\Domain\Activos\Service\ActivosService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class ActivosAction {
    private $ActivosService;

    public function __construct(ActivosService $ActivosService)
    {
        $this->ActivosService = $ActivosService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response) {
        
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        // Invoke the Domain with inputs and retain the result
        $result=$this->ActivosService->InsertarRegistro($data);

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){
        $payload=$this->ActivosService->BuscarRegistros();
        //$response->getBody()->write(json_encode(['data' => $payload]));
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        $cities = $args['cities'];
        $offset = $args['offset'];
        $limit = $args['limit'];

        $payload = $this->ActivosService->BuscarRegistro($cities, $offset, $limit);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function CountAssets(Request $request, Response $response, array $args) {

        $cities = $args['cities'];

        $payload = $this->ActivosService->ContarActivos($cities);
        $response->getBody()->write(json_encode($payload));

        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(201);
    }

    public function SearchIdOnly(Request $request,Response $response){

        $payload = $this->ActivosService->BuscarSoloId();
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function SearchByIdRes(Request $request,Response $response, array $args){

        $responsibleId = $args['responsibleId'];

        $payload = $this->ActivosService->BuscarIdResponsable($responsibleId);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function ReportFormat(Request $request, Response $response, array $args) {

        $cities = $args['cities'];
        $locationId = $args['locationId'];
        $responsibleId = $args['responsibleId'];

        $payload = $this->ActivosService->FormatoReporte($cities, $locationId, $responsibleId);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);
    }

    public function SearchPreviewRecord(Request $request,Response $response,array $args) {
        
        //Get id
        $id = $args['id'];

        $payload=$this->ActivosService->BuscarVistaPreviaRegistro($id);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  

    }

    public function UpdateRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result = $this->ActivosService->ActualizarRegistro($data);  
        $response->getBody()->write(json_encode($result));
        
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    } 

    public function UpdateAssetLocation(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->ActivosService->ActualizarUbicacionActivo($data);  
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }
    
    public function UpdateGlobalOfficial(Request $request,Response $response,array $args){

        // Collect input from the HTTP request
        //$data = (array)$request->getParsedBody();

        //Get data
        $idOld = $args['idOld'];
        $idNew = $args['idNew'];

        $result =$this->ActivosService->ActualizarGlobalFuncionario($idOld,$idNew);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args) {

        $assetId = $args['assetId'];
        $result = $this->ActivosService->EliminarRegistro($assetId);

        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function TransferResponsible(Request $request, Response $response, array $args) {

        $responsibleId = $args['responsibleId'];
        $newResponsibleId = $args['newResponsibleId'];

        $payload = $this->ActivosService->TransferirResponsable($responsibleId, $newResponsibleId);

        $response->getBody()->write(json_encode($payload));
        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(200);
    }

    public function UpdateFoKeyResponsible(Request $request, Response $response, array $args) {

        // get id asset & responsible
        $assetId = $args['assetId'];
        $responsibleId = $args['responsibleId'];

        $payload = $this->ActivosService->ActualizarForaneaResponsable($assetId, $responsibleId);
        $response->getBody()->write(json_encode($payload));

        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(200);
    }

    public function SearchById(Request $request,Response $response,array $args){

        $assetId = $args['assetId'];
        $cities = $args['cities'];

        $payload = $this->ActivosService->BuscarRegistroPorId($assetId, $cities);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function TransferAsset(Request $request, Response $response, array $args) {

        $assetId = $args['assetId'];
        $responsibleId = $args['responsibleId'];
        $locationId = $args['locationId'];

        $payload = $this->ActivosService->TrasladoActivo($assetId, $responsibleId, $locationId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    } 

    public function assetCategoryWithFields(Request $request, Response $response, array $args) {

        $assetId = $args['assetId'];

        $payload = $this->ActivosService->categoriaActivoConCampos($assetId);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function ChangeAssetStatus(Request $request, Response $response, array $args) {

        $assetId = $args['assetId'];
        $status = $args['status'];

        $payload = $this->ActivosService->CambiarEstadoDelActivo($assetId, $status);
        $response->getBody()->write(json_encode($payload));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);
    }

    public function SearchbyResponsible(Request $request, Response $response, array $args) {

        $cities = $args['cities'];
        $responsibleId = $args['responsibleId'];

        $payload = $this->ActivosService->BuscarPorResponsable($cities, $responsibleId);
        $response->getBody()->write(json_encode($payload));

        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(201);
    }

    public function SearchByDescription(Request $request, Response $response, array $args) {

        $cities = $args['cities'];
        $data = $args['data'];

        $payload = $this->ActivosService->BuscarPorDescripcion($cities, $data);
        $response->getBody()->write(json_encode($payload));

        return $response
                ->withHeader('Content-Type', 'application/json')
                ->withStatus(201);
    }
}