<?php

namespace App\Action\ActiveFields;

use App\Domain\ActiveFields\Service\ActiveFieldsService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final class ActiveFieldsAction
{
    private $ActiveFieldsService;

    public function __construct(ActiveFieldsService $ActiveFieldsService)
    {
        $this->ActiveFieldsService = $ActiveFieldsService;
    }

    public function __invoke(ServerRequestInterface $request,ResponseInterface $response): ResponseInterface {

    }

    public function InsertRecord(Request $request,Response $response) {

        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();
        // Invoke the Domain with inputs and retain the result
        $result=$this->ActiveFieldsService->InsertarRegistro($data);

        // Transform the result into the JSON representation

        // Build the HTTP response
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }

    public function SearchRecords(Request $request,Response $response){
        $payload=$this->ActiveFieldsService->BuscarRegistros();
        $response->getBody()->write(json_encode(['data' => $payload]));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);    
    }

    public function SearchRecord(Request $request,Response $response,array $args){

        $email = $args['email'];
        $pass = $args['pass'];

        $payload=$this->ActiveFieldsService->BuscarRegistro($email,$pass);
        $response->getBody()->write(json_encode($payload));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(201);  
    }

    public function UpdateRecord(Request $request,Response $response,array $args)
    {
        // Collect input from the HTTP request
        $data = (array)$request->getParsedBody();

        $result =$this->ActiveFieldsService->ActualizarRegistro($data);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function DeleteRecord(Request $request,Response $response,array $args)
    {
        $id = $args['id'];
        $result =$this->ActiveFieldsService->EliminarRegistro($id);     
        $response->getBody()->write(json_encode($result));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);   
    }

    public function UpdateDesc(Request $request, Response $response) {

        $data = (array)$request->getParsedBody();

        $result = $this->ActiveFieldsService->ActualizarDescripcion($data);
        $response->getBody()->write(json_encode($result));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(200);
    }
}