<?php

use Slim\App;
use Slim\Middleware\ErrorMiddleware;
use Selective\BasePath\BasePathMiddleware;
use \App\Middleware\CorsMiddleware;
return function (App $app) {
    // Parse json, form data and xml
    $app->addBodyParsingMiddleware();

    // Add the Slim built-in routing middleware
    $app->add(CorsMiddleware::class);
    
    $app->addRoutingMiddleware();

    $app->add(BasePathMiddleware::class);
    
    // Catch exceptions and errors
    $app->add(ErrorMiddleware::class);

    //4/01/2023
    $errorMiddleware = $app->addErrorMiddleware(true, true, true);
};